import { headers } from "next/headers";
import dynamic from "next/dynamic";
import { FetchData } from "@/libs/api";
import OffPlanCardsList from "@/sections/OffPlanCardsList";
import { localhostdomain, WorkDomain } from "@/app/domain";
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export async function generateMetadata({ params }) {
  const { types_page } = params;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "buy";
  const secparams = types_page;
  const data = await FetchData(domain, first_para, secparams);
  const { meta_title, meta_desc, meta_keywords } = data;
  const slug = types_page;
  return {
    metadataBase: new URL(`https://${domain}/buy/${slug}`),
    title: meta_title,
    description: meta_desc,
    keywords: meta_keywords,
    alternates: {
      canonical: "/",
    },
    openGraph: {
      url: "/",
    },
  };
}
export default async function page({ params }) {
  const { types_page } = params;
  const requestHeaders = headers();
  const host = requestHeaders.get("host") || "";
  const isLocalhost = host.includes(localhostdomain);
  const domain = isLocalhost ? WorkDomain : host;
  const first_para = "buy";
  const secparams = types_page;
  const data = await FetchData(domain, first_para, secparams);
  const slug = types_page;
  const {
    meta_title,
    meta_desc,
    meta_keywords,
    projects,
    short_content,
    heading1,
  } = data;
  return (
    <>
      <WebsiteSchema
        title={meta_title}
        description={meta_desc}
        keywords={meta_keywords}
        fullUrl={`https://${domain}/buy/${slug}`}
      />
      <RatingSchema title={meta_title} />
      <OffPlanCardsList
        data={projects}
        heading={heading1}
        content={short_content}
        domain={domain}
        cardsQuantity="12"
      />
    </>
  );
}
